#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Floating color bubblesMod01.fsh    by   avin  
//https://www.shadertoy.com/view/ttlfRM
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define TOTAL_LAYERS 12.0 

#define hue(h) clamp( abs( fract(h + vec4(3,2,1,0)/3.) * 6. - 3.) -1. , 0., 1.)

float hash12(vec2 p)
{
    vec3 p3  = fract(vec3(p.xyx) * .1031);
    p3 += dot(p3, p3.yzx + 33.33);
    return fract((p3.x + p3.y) * p3.z);
}
 
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord.xy) / iResolution.x + vec2(100.);    
                             
    vec3 col = vec3(0.); 
        
     
    for(float layer =1.; layer <= TOTAL_LAYERS; layer++ ) {
    
        float SIZE = (17. - layer) * .5;
        vec2 luv = uv * SIZE;
    	vec2 id = floor(luv);
    	luv = fract(luv) - 0.5;
                       
        for(float y =- 1.0; y <= 1.0; y++ ) {
        	for(float x =- 1.0; x <= 1.0; x++ ) {
                vec2 rid = id - vec2(x, y);

                float rFactor1 = hash12(rid + 542. * layer);
                float rFactor2 = hash12(rid + 159. * layer);
                
                float t = iTime*5.5/(10. + layer*5./rFactor1) + 100. * rFactor2;

                vec2 ruv = luv + vec2(x, y) +                 
                    vec2(
                        sin(iTime*.1 + t + rFactor1),
                        sin(iTime*.2 + t*.9 + rFactor2)                    
                    );            

                float l = length(ruv);            
                float ld = length(ruv - vec2(.075));  
                
                float SF = 1./min(iResolution.x,iResolution.y)*SIZE*(layer*2.);

                float d = smoothstep(SF,-SF,l-(.125 + hash12(rid + 700.)*.25));      

                // Remove some bubbles to make breath space
                d *= step(hash12(rid*75.4 + 100.), .5 + (layer/TOTAL_LAYERS));

                // Determine bubble color factor
                float colFactor = hash12(rid + 500.); // + iTime*.1;

                vec3 iCol = hue(colFactor).rgb * d * (.7 + smoothstep(.1,.5,ld)*1.);

                col = col + iCol*(.25 + (1. - layer/TOTAL_LAYERS)*.2); 
            
        	}
    	}                
    }
     
    
    
    fragColor = vec4(col, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

